/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.contentAssist.mapping;

import com.aptana.core.logging.IdeLog;
import com.aptana.editor.common.contentassist.ILexemeProvider;
import com.aptana.editor.php.PHPEditorPlugin;
import com.aptana.editor.php.indexer.IElementEntry;
import com.aptana.editor.php.indexer.IElementsIndex;
import com.aptana.editor.php.indexer.IIndexReporter;
import com.aptana.editor.php.indexer.IReportable;
import com.aptana.editor.php.indexer.PHPGlobalIndexer;
import com.aptana.editor.php.internal.contentAssist.ContentAssistFilters;
import com.aptana.editor.php.internal.contentAssist.PHPContentAssistProcessor;
import com.aptana.editor.php.internal.contentAssist.PHPContextCalculator;
import com.aptana.editor.php.internal.contentAssist.PHPTokenType;
import com.aptana.editor.php.internal.contentAssist.ParsingUtils;
import com.aptana.editor.php.internal.contentAssist.mapping.CodeLocation;
import com.aptana.editor.php.internal.contentAssist.mapping.ICodeLocation;
import com.aptana.editor.php.internal.core.builder.IBuildPath;
import com.aptana.editor.php.internal.core.builder.IModule;
import com.aptana.editor.php.internal.indexer.AbstractPHPEntryValue;
import com.aptana.editor.php.internal.indexer.ModuleSubstitutionIndex;
import com.aptana.editor.php.internal.indexer.PDTPHPModuleIndexer;
import com.aptana.editor.php.internal.indexer.UnpackedElementIndex;
import com.aptana.editor.php.internal.ui.editor.PHPSourceEditor;
import com.aptana.ide.ui.io.internal.UniformFileStoreEditorInput;
import com.aptana.parsing.lexer.Lexeme;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.ui.IEditorInput;

public class PHPOffsetMapper {
    private static final String NEW = "new";
    private boolean reportedStackIsGlobal;
    private PHPSourceEditor phpSourceEditor;
    private String namespace;
    private Map<String, String> aliases;
    private Set<String> globalImports;

    public PHPOffsetMapper(PHPSourceEditor phpSourceEditor) {
        this.phpSourceEditor = phpSourceEditor;
    }

    public IElementEntry findEntry(Lexeme<PHPTokenType> lexeme, ILexemeProvider<PHPTokenType> lexemeProvider) {
        IDocument document = this.phpSourceEditor.getDocumentProvider().getDocument((Object)this.phpSourceEditor.getEditorInput());
        String source = document.get();
        Set<IElementEntry> entries = this.collectEntries(source, lexeme);
        if (entries.isEmpty()) {
            return null;
        }
        List<IElementEntry> sortedEntries = this.sortByModule(entries);
        return sortedEntries.get(0);
    }

    public ICodeLocation[] findTargets(Lexeme<PHPTokenType> lexeme, ILexemeProvider<PHPTokenType> lexemeProvider) {
        String source = null;
        IEditorInput editorInput = this.phpSourceEditor.getEditorInput();
        try {
            int lexemePosition;
            ILexemeProvider<PHPTokenType> newLexemeProvider;
            Lexeme<PHPTokenType> importLexeme;
            int previousPartitionEnd;
            IDocument document = this.phpSourceEditor.getDocumentProvider().getDocument((Object)this.phpSourceEditor.getEditorInput());
            source = document.get();
            ITypedRegion partition = document.getPartition(lexeme.getStartingOffset());
            int n = previousPartitionEnd = partition != null ? partition.getOffset() - 1 : -1;
            if (previousPartitionEnd > 0 && ("__php_string_single".equals(partition.getType()) || "__php_string_double".equals(partition.getType())) && (importLexeme = PHPContextCalculator.findLexemeBackward(newLexemeProvider = ParsingUtils.createLexemeProvider(document, previousPartitionEnd), lexemePosition = newLexemeProvider.getLexemeFloorIndex(previousPartitionEnd - 1), new String[]{"PHP_INCLUDE", "PHP_INCLUDE_ONCE", "PHP_REQUIRE", "PHP_REQUIRE_ONCE"}, new String[]{"WHITESPACE", "PHP_TOKEN"})) != null) {
                return this.getIncludeLocation(lexeme, source);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)PHPEditorPlugin.getDefault(), (String)"Error locating code-location target", (Throwable)e);
        }
        String fullPath = null;
        IFileStore remoteFileStore = null;
        List<IElementEntry> sortedEntries = this.sortByModule(this.collectEntries(source, lexeme));
        ArrayList<CodeLocation> locations = new ArrayList<CodeLocation>(5);
        for (IElementEntry entry : sortedEntries) {
            UniformFileStoreEditorInput uniformInput;
            Object value = entry.getValue();
            if (!(value instanceof AbstractPHPEntryValue) || entry.getModule() == null) continue;
            fullPath = entry.getModule().getFullPath();
            if (editorInput instanceof UniformFileStoreEditorInput && (uniformInput = (UniformFileStoreEditorInput)editorInput).isRemote()) {
                if (uniformInput.getLocalFileStore().toString().equals(fullPath)) {
                    remoteFileStore = uniformInput.getFileStore();
                }
                fullPath = null;
            }
            if (fullPath == null && remoteFileStore == null) continue;
            AbstractPHPEntryValue phpEntryValue = (AbstractPHPEntryValue)value;
            int startOffset = phpEntryValue.getStartOffset();
            Lexeme startLexeme = new Lexeme((Object)new PHPTokenType("UNKNOWN_TOKEN"), startOffset, startOffset, "");
            if (remoteFileStore != null) {
                locations.add(new CodeLocation(remoteFileStore, (Lexeme<PHPTokenType>)startLexeme));
            }
            locations.add(new CodeLocation(fullPath, (Lexeme<PHPTokenType>)startLexeme));
        }
        return locations.toArray(new CodeLocation[locations.size()]);
    }

    private Set<IElementEntry> collectEntries(String source, Lexeme<PHPTokenType> lexeme) {
        boolean isFunctionCall = this.isFunctionCall(lexeme, source);
        boolean isConstructor = this.isConstructorCall(lexeme, source);
        int offset = lexeme.getEndingOffset();
        IModule module = this.phpSourceEditor.getModule();
        if (module == null) {
            return Collections.EMPTY_SET;
        }
        Set<IElementEntry> entries = null;
        IElementsIndex index = this.getIndex(source, offset);
        IDocument document = this.phpSourceEditor.getDocumentProvider().getDocument((Object)this.phpSourceEditor.getEditorInput());
        List<String> callPath = ParsingUtils.parseCallPath(null, source, offset, PHPContentAssistProcessor.OPS, false, document);
        if (callPath == null || callPath.isEmpty()) {
            return Collections.EMPTY_SET;
        }
        if (callPath.size() > 1) {
            entries = "->".equals(callPath.get(1)) ? PHPContentAssistProcessor.computeDereferenceEntries(index, callPath, offset, module, true, this.aliases, this.namespace) : PHPContentAssistProcessor.computeStaticDereferenceEntries(index, callPath, offset, module, true, this.aliases, this.namespace);
        } else {
            String toFind = callPath.get(callPath.size() - 1);
            boolean variableCompletion = false;
            ArrayList<IElementEntry> res = new ArrayList<IElementEntry>();
            if (toFind.length() > 0 && toFind.charAt(0) == '$') {
                variableCompletion = true;
                toFind = toFind.substring(1);
            } else {
                res.addAll(PHPContentAssistProcessor.computeDefines(toFind, index, null, true));
            }
            toFind = toFind.toLowerCase();
            res.addAll(PHPContentAssistProcessor.computeSimpleIdentifierEntries(this.reportedStackIsGlobal, this.globalImports, toFind, variableCompletion, index, true, module, false, this.namespace, this.aliases));
            if (res != null) {
                entries = new LinkedHashSet<IElementEntry>();
                entries.addAll(res);
            }
        }
        if (entries == null) {
            return Collections.EMPTY_SET;
        }
        entries = isFunctionCall && !isConstructor ? ContentAssistFilters.filterAllButFunctions(entries, index) : (isConstructor ? ContentAssistFilters.filterAllButClasses(entries, index) : ContentAssistFilters.filterAllButVariablesAndClasses(entries, index));
        if (entries == null || entries.size() == 0) {
            return Collections.EMPTY_SET;
        }
        return entries;
    }

    private ICodeLocation[] getIncludeLocation(Lexeme<PHPTokenType> lexeme, String source) {
        IModule includedModule;
        block8: {
            Path path;
            IBuildPath buildPath;
            IModule module;
            block7: {
                String moduleName = this.getIncludeModuleName(lexeme, source);
                if (moduleName == null) {
                    return null;
                }
                module = this.phpSourceEditor.getModule();
                if (module == null) {
                    return null;
                }
                buildPath = module.getBuildPath();
                if (buildPath == null) {
                    return null;
                }
                try {
                    path = new Path(moduleName);
                    if (!path.isAbsolute()) break block7;
                    return null;
                }
                catch (Throwable throwable) {
                    return null;
                }
            }
            includedModule = buildPath.resolveRelativePath(module, (IPath)path);
            if (includedModule != null) break block8;
            return null;
        }
        Lexeme startLexeme = new Lexeme((Object)new PHPTokenType("UNKNOWN_TOKEN"), 0, 0, "");
        return new CodeLocation[]{new CodeLocation(includedModule.getFullPath(), (Lexeme<PHPTokenType>)startLexeme)};
    }

    private String getIncludeModuleName(Lexeme<PHPTokenType> lexeme, String source) {
        String includeString;
        if (lexeme != null && (includeString = lexeme.getText()) != null && includeString.length() > 2) {
            return includeString.substring(1, includeString.length() - 1);
        }
        return null;
    }

    private boolean isConstructorCall(Lexeme<PHPTokenType> lexeme, String source) {
        int searchStringPos = NEW.length() - 1;
        int i = lexeme.getStartingOffset() - 1;
        while (i >= 0) {
            if (searchStringPos == -1) {
                return true;
            }
            if (i > source.length() - 1) {
                return false;
            }
            char ch = source.charAt(i);
            if (ch == NEW.charAt(searchStringPos)) {
                --searchStringPos;
            } else if (!Character.isWhitespace(ch)) {
                return false;
            }
            --i;
        }
        return searchStringPos == -1;
    }

    private boolean isFunctionCall(Lexeme<PHPTokenType> lexeme, String source) {
        int i = lexeme.getEndingOffset() + 1;
        while (i < source.length()) {
            char ch = source.charAt(i);
            if (ch == '(') {
                return true;
            }
            if (!Character.isWhitespace(ch)) {
                return false;
            }
            ++i;
        }
        return false;
    }

    public IElementsIndex getIndex(String content, int offset) {
        IModule currentModule = this.phpSourceEditor.getModule();
        if (currentModule == null) {
            return PHPGlobalIndexer.getInstance().getIndex();
        }
        final UnpackedElementIndex index = new UnpackedElementIndex();
        PDTPHPModuleIndexer indexer = new PDTPHPModuleIndexer(false, offset);
        indexer.setUpdateTaskTags(false);
        indexer.indexModule(content, currentModule, new IIndexReporter(){

            @Override
            public IElementEntry reportEntry(int category, String entryPath, IReportable value, IModule module) {
                return index.addEntry(category, entryPath, value, module);
            }
        });
        this.reportedStackIsGlobal = indexer.isReportedScopeGlobal();
        this.globalImports = indexer.getGlobalImports();
        this.namespace = indexer.getNamespace();
        this.aliases = indexer.getAliases();
        ModuleSubstitutionIndex result = new ModuleSubstitutionIndex(currentModule, index, PHPGlobalIndexer.getInstance().getIndex());
        return result;
    }

    private List<IElementEntry> sortByModule(Set<IElementEntry> entries) {
        if (entries == null) {
            return null;
        }
        ArrayList<IElementEntry> currentModuleEntries = new ArrayList<IElementEntry>();
        ArrayList<IElementEntry> otherEntries = new ArrayList<IElementEntry>();
        IModule currentModule = this.phpSourceEditor.getModule();
        for (IElementEntry entry : entries) {
            if (currentModule != null && entry.getModule() != null && currentModule.equals(entry.getModule())) {
                currentModuleEntries.add(entry);
                continue;
            }
            otherEntries.add(entry);
        }
        ArrayList<IElementEntry> toReturn = new ArrayList<IElementEntry>();
        toReturn.addAll(currentModuleEntries);
        toReturn.addAll(otherEntries);
        return toReturn;
    }
}

